

#ifdef manual

#endif


*     Object                 number of elements  index before
*     -------------------    ------------------  ------------
*     derivative matrix A    NX*NF   A(.)        0
*     steps                  NX      ST(.)       NF*NX
*     limits                 2*NX    XL(2,.)     NX*(NF+1)
*     transform flag         NX                  INDTR
*     copy of F(.)           NF      FC(.)       INDFC
*     copy of F(.)           NF      HH(.)       INDHH
*
*     saved X(.)             NX                  INDXS
*     step                   NX                  INDDX                 
*     previous step          NX                  INDXP
*     right-hand side        NX+NF               INDRH
*     weight matrix          (NXF*NXF+NXF)/2     INDWM
*     matrix diagonal        NX+NF               INDIA
*     next pointer           NX+NF               INDQN
*                   
*     Transformed variable
*
*     X(i) remains unchanged for F(j) calculation    -
*     covariance matrix transformed (initially)      done
*     derivatives transformed                        done  
*     corrections transformed
*     final covariane matrix transformed back        done
*


      SUBROUTINE APLCON(NVAR,MCST)         ! dimension parameters 
*     initialize and define dimension  NVAR of X,
*                                      MCST of Y/F
      IMPLICIT NONE
      INTEGER NVAR,MCST,IJ 
#include "comcfit.inc"
#include "nauxfit.inc"
      LOGICAL START
      DATA START/.TRUE./ 
*     ...
      IF(START) THEN
         START=.FALSE.
         NCASE=0
      END IF 
      NCASE=NCASE+1       ! counter for cases
      NX    =NVAR         ! number of variabales 
      NF    =MCST         ! number of constraint equations
      NDPDIM=NAUX         ! dimension of AUX array
      LUNSIM=6            ! printout unit (default)
      IPR=5               ! default is 5
      DERFAC=1.0D-3       ! derivative factor
      DERUFC=1.0D-5       ! factor or unmeasured variable
      DERLOW=1.0D-2       ! factor for lower limit 
      EPSF  =1.0D-6       ! accuracy limit
      ITERMX=100          ! max number of iterations
      INIT  =0
      ISTAT =0            ! init phase
*     ...
*     indices for APLOOP and APROPA (propagation of uncertainties)
      INDTR=NX*(NF+3)     ! pointer to transform flags
      INDFC=INDTR+NX      ! pointer to FC(NF) = copy of F(NF)
      INDHH=INDFC+NF      ! pointer to HH(NF) = copy of F(.)
      NDTOT=INDHH+NF      ! total (so far)
      NAUXC=NAUX          ! copy AUX dimension
      IF(NDTOT.GT.NAUX) THEN
         WRITE(*,*) ' '
         WRITE(*,*) 'APLCON  - for constrained least squares'
         WRITE(*,*) 'Case ',NCASE
         WRITE(*,*) 'Insufficient space in internal array AUX(',NAUX,')'
         WRITE(*,*) 'Required:',NDTOT,' elements (at least)'
         WRITE(*,*) '-> stop'  
         WRITE(*,*) ' '
         STOP
      END IF

      DO IJ=1,NDTOT ! NX*(NF+3)+NF+NX+NF
       AUX(IJ)=0.0D0      ! clear  A(.), ST(.),XL(2,.)
      END DO
      DO IJ=NX*NF+1,NX*NF+NX      
       AUX(IJ)=-1.0D0     ! set ST(.)=-1.0: step undefined 
      END DO

      NDF   =0            ! reset n d f
      CHISQ =0.0D0        ! reset chi square
      NCALLS=0            ! reset number of calls 
      END


      SUBROUTINE APLOOP(X,VX,F, IRET)      ! steering routine for loop  
      IMPLICIT NONE
      INTEGER IRET,JRET 
      DOUBLE PRECISION X(*),VX(*),F(*)
#include "comcfit.inc" 
#include "nauxfit.inc"
*     ... 
      IF(ISTAT.EQ.0.AND.IPR.GE.3) THEN
         WRITE(LUNSIM,*) ' '
         WRITE(LUNSIM,*) 'APLCON - for constrained least squares'
         WRITE(LUNSIM,*) '======             Version  01/02/2009'
         WRITE(LUNSIM,*) ' ' 
      END IF 

      NCALLS=NCALLS+1
      IRET=-1                          ! loop ...
 10   IF(ISTAT.EQ.1) THEN ! make derivative calculation  
         CALL IPLDER(X,F, AUX,              ! derivative matrix A
     +                    AUX(1+NX*NF),     ! steps  ST(.)
     +                    AUX(1+NX*(NF+1)), ! limits XL(2,.)
     +                    AUX(1+INDFC),     ! copy FC(.)
     +                    AUX(1+INDHH),     ! copy HH(.)
     +                    AUX(1+INDTR),     ! copy TRFLAG(.)
     +                    JRET) 
         IF(JRET.LT.0) RETURN    !...for constraint calculation
      END IF

      CALL IPLCON(X,VX,F, AUX,AUX(1+INDTR),IRET)    ! step calculation
      IF(ISTAT.EQ.1) GOTO 10           ! repeat  

      IF(IRET.GE.0) THEN ! final return
          CALL APNAME(0,' ') ! reset parameter names 
      END IF

      END


      SUBROUTINE APROPA(X,VX,Y,VY, IRET)   ! error propagation Y = Y(X)
*     propagation of uncertainties for Y = function Y(X) of X
*
      IMPLICIT NONE
      INTEGER IRET,I,J,JRET
      DOUBLE PRECISION X(*),VX(*),Y(*),VY(*)
#include "comcfit.inc"
#include "nauxfit.inc"
      DATA ICNT/0/
*     ...
      IF(ISTAT.EQ.0.AND.IPR.GE.3) THEN
         WRITE(LUNSIM,*) ' '
         WRITE(LUNSIM,*) 'APLCON - for propagation of uncertainties'
         WRITE(LUNSIM,*) '======                Version  01/02/2009'
         WRITE(LUNSIM,*) ' ' 
      END IF

      IF(ISTAT.NE.0) GOTO 10
      IPR=4
      
*     initialization ---------------------------------------------------
  
      IF(IPR.GE.4) THEN
          WRITE(LUNSIM,*) ' '
          WRITE(LUNSIM,*) 'Transformation of covariance matrix',NX,
     +                    ' ->',NF,' parameters'
      END IF              

      IF(IPR.GT.5) THEN
         WRITE(LUNSIM,*) '  x-vector:'
         WRITE(LUNSIM,102) (X(I),I=1,NX)  
      END IF
      IF(IPR.GT.5.AND.NX.LE.128) THEN
         WRITE(LUNSIM,*) 'using AUX array with ',INDHH+NF,' elements'
         CALL CFPRV(LUNSIM,X,VX,NX)
      END IF
      IFLG=ICNT      ! flag for comparison of derivatives
      ICNT=ICNT+1
*                    A(.)  ST(.)          XL(2,.)
      CALL IPLMAT(X,VX,AUX,AUX(1+NX*NF),AUX(1+INDTR)) ! AUX(1+NX*(NF+1)))

      IRET=-1
      DO J=1,NF
       AUX(INDFC+J)=Y(J) ! FC(J) is used in IPLDER
      END DO
      ISTAT=1     ! initialization done in ERRPRP

*     numerical calculation of derivates (Jacobian) -------------------- 

*                      A(.)  ST(.)          XL(2,.)                         
 10   CALL IPLDER(X,Y, AUX,AUX(1+NX*NF),AUX(1+NX*(NF+1)),
     +   AUX(1+INDFC),AUX(1+INDHH),AUX(1+INDTR),JRET)
      IF(JRET.LT.0) RETURN ! -> new Y(.) evaluation
      IF(IPR.GT.5) CALL CFGMPR(LUNSIM,AUX,NF,NX,'derivative matrix')

*     transformation --------------------------------------------------- 

      IRET=0      ! done (external)
      ISTAT=0     ! done (internal) in ERRPRP
      CALL SMAVAT(VX,AUX,VY,NX,NF)
      DO I=1,NF
       Y(I)=AUX(INDFC+I) ! copy values back
      END DO 
      IF(IPR.GT.4) THEN
         WRITE(LUNSIM,*) '  y-vector:'
         WRITE(LUNSIM,102) (Y(I),I=1,NF)
      END IF
      IF(IPR.GE.3.AND.NX.LE.32) CALL CFPRV(LUNSIM,Y,VY,NF)
  102 FORMAT(3X,5G12.5)
      END


      SUBROUTINE IPLMAT(X,VX,A,ST,TRFLAG)         ! define initial steps
*     check derivative matrix, set flag NUM ...
*        and define steps for num. diff. from covariance matrix
*        NUM = 0      analytical derivatives
*        NUM = 1      numerical derivatives
*        NUM = 2      numerical derivatives, compare with analytical
*     IPLMAT is only called once
*
      IMPLICIT NONE
      INTEGER I,J,IJ,II,IJSYM
      DOUBLE PRECISION VII 
#include "comcfit.inc"
      DOUBLE PRECISION X(*),VX(*),A(*),ST(*),TRFLAG(*)
*     ...
      NUM=1                     ! numeric   
      DO IJ=1,NX*NF
       IF(A(IJ).NE.0.0) NUM=0   ! analytic
      END DO
      IF(NUM.EQ.0.AND.IFLG.EQ.0.AND.IPR.GE.0) NUM=2 ! force numdev

      II=0
      DO I=1,NX
       II=II+I
       VII=ABS(VX(II)) ! original diagonal element
       IF(TRFLAG(I).EQ.2.0D0) THEN ! logarithmic transformation
          IF(X(I).LE.0.0) THEN
             IF(IPR.GE.2) THEN ! error condition
                WRITE(LUNSIM,*)
     +          'Variable',I,' is',X(I),' reset to normal'
             END IF 
             TRFLAG(I)=0.0D0 ! reset: X(i) has to be positive
          END IF
       ELSE IF(TRFLAG(I).EQ.3.0D0) THEN ! sqrt transformation   
          IF(X(I).LE.0.0) THEN
             IF(IPR.GE.2) THEN ! error condition
                WRITE(LUNSIM,*)
     +          'Variable',I,' is',X(I),' reset to normal'
             END IF
             TRFLAG(I)=0.0D0 ! reset: X(i) has to be positive
          END IF
       END IF
       IF(VII.NE.0.0D0.AND.NUM.NE.0) THEN     ! measured variable
          IF(ST(I).GT.0.0D0) THEN
             ST(I)=MIN(ST(I),DERFAC*SQRT(VII)) ! user step, if smaller 
          ELSE IF(ST(I).LT.0.0D0) THEN
             ST(I)=DERFAC*SQRT(VII)            ! step from cov matrix
             ST(I)=MIN(ST(I),DERLOW*MAX(1.0D-6,ABS(X(I))))
          END IF
       ELSE IF(VII.EQ.0.0D0) THEN             ! unmeasured variable
          NDF=NDF-1
          IJ=II-I
          DO J=1,NX
           IF(J.LE.I) IJ=IJ+1
           VX(IJ)=0.0                       ! clear matrix elment
           IF(J.GE.I) IJ=IJ+J
          END DO
          IF(ST(I).LT.0.0D0) THEN
             ST(I)=DERUFC*MAX(1.0D0,ABS(X(I)))
          END IF 
       END IF
       IF(ST(I).EQ.0.0D0) THEN
          TRFLAG(I)=-1.0D0 !  fixed 
       ELSE
          IF(TRFLAG(I).EQ.2.0D0) THEN
             ST(I)=ST(I)/X(I)       ! change step to log step
          ELSE IF(TRFLAG(I).EQ.3.0D0) THEN
             ST(I)=0.5D0*ST(I)/SQRT(X(I)) ! change step to sqrt step 
          END IF 
       END IF  
      END DO
      DO I=1,NX 
       IF(TRFLAG(I).EQ.2.0D0) THEN ! transform covariance matrix for logn
          DO J=1,NX
           VX(IJSYM(I,J))=VX(IJSYM(I,J))/X(I)
           IF(I.EQ.J) VX(IJSYM(I,J))=VX(IJSYM(I,J))/X(I)
          END DO  
       ELSE IF(TRFLAG(I).EQ.3.0D0) THEN !  for sqrt 
          DO J=1,NX
           VX(IJSYM(I,J))=VX(IJSYM(I,J))*0.5D0/SQRT(X(I))
           IF(I.EQ.J) VX(IJSYM(I,J))=VX(IJSYM(I,J))*0.5D0/SQRT(X(I))
          END DO 
       END IF 
      END DO
      END


      SUBROUTINE IPLDER(X,F, A,ST,XL,FC,HH,TRFLAG, JRET) ! derivative calculation
*     derivative calculation
*
*     cases: all ST(.) = 0 -> return with JRET=0
*            otherwise        return with JRET=-1
*            until last par   return with JRET=0 
*      
      IMPLICIT NONE
      INTEGER JRET,I,ILR,IJ,J
#include "comcfit.inc"
      DOUBLE PRECISION X(*),F(*),A(*),ST(*),XL(2,*),FC(*),HH(*)
      DOUBLE PRECISION XD(2),XSAVE,DER,STM,TRFLAG(*) 
      LOGICAL LIMDEF
*     ...
      JRET=-1 
      IF(INIT.NE.0) GOTO 20  
      INIT= 1
      I=0                       ! initialize

*     next variable
   10 I=I+1
      IF(ST(I).EQ.0.0) GOTO 30  ! skip fixed variable
      XSAVE=X(I)                ! save new variable
      ILR=0                     ! define steps
      LIMDEF=XL(1,I).NE.XL(2,I) ! true if limits defined
      IF(LIMDEF) THEN
         IF(XSAVE+ST(I).GT.XL(2,I).OR.XSAVE-ST(I).GT.XL(1,I)) THEN
            STM=0.9999*MIN(XL(2,I)-XSAVE,XSAVE-XL(1,I)) ! minimal step size
            IF(3.0*STM.GT.ST(I)) THEN
               ST(I)=STM           ! user smaller symmetric step
            ELSE 
               STM=0.4999*MAX(XL(2,I)-XSAVE,XSAVE-XL(1,I)) ! minimal step size 
               IF(2.0*STM.LT.ST(I)) ST(I)=STM 
               IF(ST(I).LT.XL(2,I)-XSAVE) THEN
                  XD(1)=XSAVE+ST(I)
                  XD(2)=XSAVE+ST(I)*2.0 ! + one-sided steps
                  ILR=1
               ELSE
                  XD(1)=XSAVE-ST(I)
                  XD(2)=XSAVE-ST(I)*2.0 ! - one-sided steps
                  ILR=2  
               END IF
            END IF
         END IF
      END IF 
      IF(ILR.EQ.0) THEN
 19      IF(TRFLAG(I).LE.1.0D0) THEN
            XD(1)=XSAVE+ST(I)   ! symmetric (two-sided) steps
            XD(2)=XSAVE-ST(I)
         ELSE IF(TRFLAG(I).EQ.2.0D0) THEN ! log-normal
            XD(1)=EXP(LOG(XSAVE)+ST(I))
            XD(2)=EXP(LOG(XSAVE)-ST(I))
         ELSE IF(TRFLAG(I).EQ.3.0D0) THEN ! sqrt
            IF(ST(I)**2.GE.XSAVE) THEN
               IF(XSAVE.LE.0.0D0) THEN
                  IF(IPR.GT.1) WRITE(LUNSIM,*)
     +            'Variable',I,' is',X(I),' reset to normal'
                  TRFLAG(I)=0.0
                  GOTO 19
               ELSE
                  ST(I)=0.9D0*SQRT(XSAVE)
               END IF
            END IF
            XD(1)=(SQRT(XSAVE)+ST(I))**2  
            XD(1)=(SQRT(XSAVE)-ST(I))**2
         END IF
      END IF
      X(I)=XD(1)                ! first step
      I=-I
      RETURN 

   20 IF(I.LT.0) THEN
         I=-I                   ! ... and set next step
         X(I)=XD(2)
         DO J=1,NF
          HH(J)=F(J)            ! save constraint values ...
         END DO
         RETURN
      END IF

      X(I)=XSAVE                ! restore variable I
      IJ=I                      ! derivative calculation
      DO J=1,NF
       IF(ILR.EQ.0) THEN        ! symmetric formula
          DER=0.5D0*(HH(J)-F(J))/ST(I) ! numerical 1. derivative
       ELSE                     ! asymmetric formula
          DER=0.5D0*(3.0D0*FC(J)+F(J)-4.0D0*HH(J))/ST(I)
          IF(ILR.EQ.2) DER=-DER ! sign
       END IF
       IF(NUM.EQ.2) THEN        ! compare derivatives for NUM=2
          IF(ABS(A(IJ)-DER).GT.0.005D0*(ABS(A(IJ))+ABS(DER))) THEN
             WRITE(LUNSIM,101) J,I,A(IJ),DER
          END IF
       END IF
       A(IJ)=DER                ! insert into A
       IJ=IJ+NX
      END DO

   30 IF(I.LT.NX) GOTO 10       ! test end-condition - continue
      JRET=0
      INIT=0                    ! end-of differentiation
      IF(NUM.EQ.2) NUM=0        ! now only numerical

  101 FORMAT(/' Derivative dF(',I2,')/dX(',I2,') = ',G15.5,' versus ',
     + G15.5,' (=numerical with >1% deviation) '/)
      END



      SUBROUTINE IPLCON(X,VX,F, AUX,TRFLAG,IRET)  ! internal steering routine
      IMPLICIT NONE
      INTEGER I,J,IRET
      DOUBLE PRECISION X(*),VX(*),F(*), AUX(*),TRFLAG(*)
#include "comcfit.inc"
      CHARACTER*19 TEXT(5)
      DATA         TEXT   /'Chisquare too high ',
     +                     'Too many iterations',
     +                     'Unphysical region  ',
     +                     'NDF less or equal 0',
     +                     'AUX dimension small'/
*     --------------------------------------------
*
*     ISTAT = 0    IRET = 0        init
*           = 0         = 1,2,3,4  non-convergence
*           = 1         = -1       continue diff
*           = 2         = -2       continue
*     ...
      IF(ISTAT.NE.0) GOTO 20    ! no more initialization 
*     initialization for ISTAT=0 ---------------------------------------
      IFLG=ICNT                 ! initialization
      ICNT=ICNT+1
      NXF=NX+NF                 ! total number of fit equations
      MXF=(NXF*NXF+NXF)/2       ! number elements symmetric matrix

      INDXS=INDHH+NF            ! save X(.)        pointer
      INDDX=INDXS+NX            ! step
      INDXP=INDDX+NX            ! previos step
      INDRH=INDXP+NX            ! right-hand side
      INDWM=INDRH+NXF           ! weight matrix
      INDIA=INDWM+MXF           ! matrix diagonal
      INDQN=INDIA+NXF           ! next pointer
      NDTOT=INDQN+NXF           ! total

      IF(NDTOT.GT.NAUXC.AND.IPR.GT.0) THEN
         WRITE(LUNSIM,*) ' '
         WRITE(LUNSIM,*) 'Insufficient space in internal array AUX(',
     +              NAUXC,')'
         WRITE(LUNSIM,*) 'Required:',NDTOT,' elements'
         WRITE(LUNSIM,*) ' '
         STOP
      END IF
      NDF=NF                    ! nr of degrees of freedom
                   !   A(.)  ST(.)
      CALL IPLMAT(X,VX,AUX,          ! derivative matrix A(.)
     +                 AUX(1+NX*NF), ! steps ST(.)
     +                 AUX(1+INDTR)  ! transformation flags
     +                 ) ! test cov.matrix

                   !        XL(2,.)
      CALL CIUNPH(X,AUX(1+NX*(NF+1)) ! limits XL(2,.)
     +                 ) ! test initial values
      IF(NDF.LT.0)   IRET=4     ! no degrees of freedom      
      IF(IUNPH.NE.0) IRET=3     ! unphysical 
      IF(IRET.GT.0) GOTO 30     ! error exit

      FTEST=0.0                 ! initial value of FTEST
      FRMS=0.0 
      DO J=1,NF
       FTEST=FTEST+ABS(F(J))
       FRMS=FRMS+F(J)**2
      END DO
      FTEST=MAX(1.0D-16,FTEST/FLOAT(NF))   ! average
      FRMS=MAX(1.0D-16,SQRT(FRMS/FLOAT(NF)))
      DECXP=LOG10(FTEST)

      ITER=0
      NCST=0
      CHISQ=0.

*     Printout for constrained fit -------------------------------------

      IF(IPR.GE.3) THEN
         WRITE(LUNSIM,*) ' '
         WRITE(LUNSIM,101) ' Constrained least squares fit:'
         WRITE(LUNSIM,101) '                         case',NCASE 
         WRITE(LUNSIM,101) '              nr of variables',NX
         WRITE(LUNSIM,101) '            nr of constraints',NF
         WRITE(LUNSIM,101) '           degrees of freedom',NDF     
         WRITE(LUNSIM,102) '                      epsilon',EPSF
         WRITE(LUNSIM,102) '     factors for numer. diff.',DERFAC,
     +                     DERUFC,DERLOW
         WRITE(LUNSIM,101) '          used array elements',NDTOT
         WRITE(LUNSIM,101) '         total array elements',NDPDIM     
      END IF

      IF(IPR.GE.4) THEN 
         WRITE(LUNSIM,110)
         WRITE(LUNSIM,111) ITER,NCALLS,FRMS,FTEST
      END IF 

      IF(IPR.GE.6.AND.NX.LE.32) THEN
         CALL CFPRV(LUNSIM,X,VX,NX)
      END IF
      IF(NDTOT.GT.NDPDIM) IRET=5
      IF(IRET.GT.0) GOTO 30

*     calculations -----------------------------------------------------  

 20   CALL JPLCON(X,VX,F, AUX,AUX(1+INDXS),AUX(1+INDDX),AUX(1+INDXP),
     +                        AUX(1+INDRH),AUX(1+INDWM),AUX(1+INDIA),
     +                        AUX(1+INDQN),TRFLAG,IRET)
      IF(ISTAT.EQ.1) RETURN ! GOTO 10 ! repeat derivative calculation
      IF(IRET.LT.0)  RETURN     ! continue fit loop 

*     final return with IRET = 0,1,2,3,4,5 -----------------------------

 30   IF(IPR.GE.1) THEN      ! print
         IF(IRET.EQ.0) THEN     ! convergence
            IF(IPR.GE.3) THEN
               WRITE(LUNSIM,*) ' '
               WRITE(LUNSIM,119) ITER,CHISQ,NDF
            END IF     

            IF(IPR.GE.4) THEN
               IF(NX.LE.128) THEN
                  CALL CFPRVP(LUNSIM,X,VX,TRFLAG,AUX,NX)
                  IF(IPR.GE.5) THEN
                     WRITE(LUNSIM,*) ' '
                     CALL CFCORR(LUNSIM,VX,NX)
                  END IF 
               ELSE 
                  WRITE(LUNSIM,*) '  x-vector (fitted):'
                  WRITE(LUNSIM,109) (X(I),I=1,NX)
               END IF
               WRITE(LUNSIM,*) ' '
            END IF              
         ELSE IF(IPR.GE.3) THEN  ! non-convergence (IRET > 0)
            WRITE(LUNSIM,105) ITER,IRET,TEXT(IRET)
            WRITE(LUNSIM,*) ' ' 
         END IF
      END IF 
      ISTAT=0                   ! final status reset

*     formats ----------------------------------------------------------
 101  FORMAT(3X,A30,I7)
 102  FORMAT(3X,A30,5X,1P,3E8.1)
 109  FORMAT(3X,5G12.5)
 105  FORMAT(' No convergence (',I3,' ITER, IRET =',I2,')  ',A)
 119  FORMAT('Convergence after',I7,' iterations with chi^2=',G15.8,
     +       '  ndf=',I4)
  110 FORMAT(/'Iteration    calls      chi^2     Frms        |F| ',
     +       5X,'~log10 ~dlog10')
  111 FORMAT(1X,I5,2X,I10,13X,E11.2,E11.2)
      END 



      SUBROUTINE JPLCON(X,VX,F, AUX,XS,DX,XP,R,W,DIAG,QNEXT,TRFLAG,IRET)
      IMPLICIT NONE
      INTEGER I,J,K,II,IA,NRANK,IRET,ND,IJSYM
      DOUBLE PRECISION X(*),VX(*),F(*),AUX(*),TRFLAG(*)
      DOUBLE PRECISION XS(*),DX(*),XP(*),R(*),W(*),DIAG(*),QNEXT(*)
      
#include "comcfit.inc"
      DOUBLE PRECISION SCALXY,SMCHI,ALPHA,SLCHI,GAMMA,SMCHL
      DOUBLE PRECISION ALPHE,GAMME,DECSL,DECXL
*
      DOUBLE PRECISION WEIGHT

*     statement function for ...
*     chisquare limit for +k sigma and nd degrees of freedom is
*     approximately
      DOUBLE PRECISION CHLIM 
      CHLIM(K,ND)=0.5*(FLOAT(K)+SQRT(FLOAT(2*ND+1)))**2
*     ...
      IF(ISTAT.EQ.1) GOTO 20 ! 
      IF(ISTAT.EQ.2) GOTO 40 !  

*     ISTAT=0 init and prepare iteration -------------------------------

      DO I=1,NX                 ! executed once
       XS(I)=X(I)               ! save initial X values
       DX(I)=0.0                ! reset correction DX
      END DO

 10   ISTAT=1                   ! prepare iteration 
      NCST=0
      DO  I=1,NX
       R(I)=0.0                 ! define right hand side of equation 
      END DO
      DO J=1,NF
       AUX(INDFC+J)=F(J)
       R(NX+J)=-F(J)
      END DO
      IF(ITER.NE.0) THEN        ! improve steps ST(.)
         II=0
         DO I=1,NX ! define steps =  sigma from W (previous inv. matrix)
          II=II+I
          IF(AUX(NF*NX+I).NE.0.0.AND.W(II).NE.0.0) THEN
             AUX(NF*NX+I)=MIN(AUX(NF*NX+I),DERFAC*SQRT(ABS(W(II)))) 
          END IF
         END DO
      END IF
      RETURN 
 
*     ISTAT=1 derivative matrix is ready, construct matrix W ... -------

 20   IF(IPR.GT.5.AND.ITER.EQ.1)
     +    CALL CFGMPR(LUNSIM,AUX,NF,NX,'derivative matrix')
      ITER=ITER+1
      IA=0
      DO J=1,NF
       R(NX+J)=R(NX+J)+SCALXY(AUX(IA+1),DX,NX) 
       AUX(INDHH+J)=R(NX+J)     ! right hand side for Chi**2
       IA=IA+NX
      END DO

      DO I=1,(NX*NX+NX)/2
       W(I)=-VX(I)              ! copy -VX(.) into W_11
      END DO
      
      II=0
      DO I=1,NX
       II=II+I
       IF(TRFLAG(I).EQ.1.0D0) THEN ! Poisson
          W(II)=-MAX(ABS(X(I)),1.0D0)
       END IF 
      END DO 

      CALL DUMINV(AUX, W,R,NX,NF, 1, NRANK, DIAG,QNEXT)
      CHSQP=CHISQ                             ! current chi^2
      CHISQ=-SCALXY(AUX(INDHH+1),R(NX+1),NF)  ! next chi^2

*     exponential smoothing of logs
      ALPHA=0.5D0
      GAMMA=0.1D0
      IF(ITER.EQ.1) THEN
         SMCHI=CHISQ
         SLCHI=0.0D0
      ELSE
         SMCHL=SMCHI
         SMCHI=ALPHA*CHISQ+(1.0D0-ALPHA)*(SMCHI+SLCHI)
         SLCHI=GAMMA*(SMCHI-SMCHL)+(1.0D0-GAMMA)*SLCHI 
      END IF 
      IF(IPR.GE.7) CALL CFGMPR(LUNSIM,R,1,NXF,'R after solution')

      WEIGHT=1.0D0
      IF(ITER.GT.1.AND.CHISQ.GE.2.00D0*CHSQP) WEIGHT=0.1D0
      IF(ITER.GT.1.AND.CHISQ.GE.3.00D0*CHSQP) WEIGHT=0.05D0   

      DO I=1,NX
       XP(I)=DX(I)    ! save previous corrections
       DX(I)=R(I)     ! new correction
       DX(I)=WEIGHT*DX(I)+(1.0D0-WEIGHT)*XP(I) ! reduce step 
      END DO

 30   DO I=1,NX
       IF(TRFLAG(I).LE.1.0D0) THEN 
          X(I)=XS(I)+DX(I) ! correct x and return to test constraints
       ELSE IF(TRFLAG(I).EQ.2.0D0) THEN ! log-normal
          X(I)=EXP(LOG(XS(I))+DX(I))
       ELSE IF(TRFLAG(I).EQ.3.0D0) THEN ! sqrt
          X(I)=(SQRT(XS(I))+DX(I))**2
       END IF
      END DO
      ISTAT=2 ! test constraints 
      RETURN 

*     ISTAT=2 test constraints, unphysical flag, cutsteps --------------

 40   FTESTP=FTEST              ! previous |F| test value
      FTEST=0.0 
      FRMS=0.0                
      DO I=1,NF
       FTEST=FTEST+ABS(F(I))    ! sum |F|
       FRMS=FRMS+F(I)**2
      END DO
      FTEST=MAX(1.0D-16,FTEST/FLOAT(NF))     ! average 
      FRMS=MAX(1.0D-16,SQRT(FRMS/FLOAT(NF)))
      ALPHE=0.5D0
      DECXL=DECXP
      IF(ITER.LE.1) DECSL=-1.0D0
      DECXP=ALPHE*0.5D0*LOG10(FTEST*FTESTP)+(1.0D0-ALPHE)*DECXP
      GAMME=0.75D0
      DECSL=GAMME*MAX(-2.0D0,MIN(DECXP-DECXL,2.0D0))+(1.0D0-GAMME)*DECSL

      IF(IPR.GE.4) THEN  
         IF(NCST.EQ.0) THEN
            WRITE(LUNSIM,111) ITER,NCALLS,CHISQ,FRMS,FTEST,DECXP,DECSL
         ELSE
            WRITE(LUNSIM,112) ITER,NCST,NCALLS,FRMS,FTEST 
         END IF 
      END IF

      IF(IPR.GE.7.AND.NCST.EQ.0) THEN
         CALL CFGMPR(LUNSIM,X,NX,1,'of X-values')
         CALL CFGMPR(LUNSIM,F,NF,1,' of constraint function values')
      END IF

      IF(IUNPH.NE.0.OR.(FTEST.GT.2.0D0*FTESTP+EPSF.AND.ITER.GT.1))THEN ! 1.1
*        divergence, make cut steps
         NCST=NCST+1            ! divergence  
         IF(NCST.LT.2) THEN
            WEIGHT=0.25D0
            IF(FTEST/FTESTP.GT. 5.0D0) WEIGHT=0.1D0
            IF(FTEST/FTESTP.GT.10.0D0) WEIGHT=0.05D0
C            IF(FTEST/FTESTP.GT.50.0D0) WEIGHT=-0.5D0
            DO I=1,NX
             DX(I)=WEIGHT*DX(I)+(1.0D0-WEIGHT)*XP(I) ! make cutstep
            END DO
            IF(IPR.GE.5) THEN
               WRITE(LUNSIM,*) 'Cut step ',NCST,'  WEIGHT=',WEIGHT
            END IF
            GOTO 30             ! try reduced DX
         END IF
      END IF

      IF(NCST.NE.0.OR.ITER.LT.2)       GOTO 50  ! no cutstep, > 1 iters
      IF(ABS(CHISQ-CHSQP).GT.0.0005D0) GOTO 50  ! stable function value
      IF(FTEST.LT.EPSF)                GOTO 45  ! |F| small
*     check for |F| stability
      IF(ABS(DECSL).GT.0.1D0)          GOTO 50  ! |F| stable 
     
*     convergence reached ---------------------------------------------- 

 45   II=0                      ! pull calculation
      DO I=1,NX
       II=II+I
       AUX(I)=0.0
       IF(VX(II).GT.0.0) THEN
          IF(VX(II)-W(II).GT.0.0) AUX(I)=DX(I)/SQRT(VX(II)-W(II))
       END IF
      END DO
      DO I=1,(NX*NX+NX)/2
        VX(I)=W(I)              ! copy fitted covarinace matrix
      END DO
      DO I=1,NX                 ! transformation back   
       IF(TRFLAG(I).EQ.2.0D0) THEN
          DO J=1,NX ! log-normal
           VX(IJSYM(I,J))=VX(IJSYM(I,J))*X(I)
           IF(I.EQ.J) VX(IJSYM(I,J))=VX(IJSYM(I,J))*X(I)
          END DO
       ELSE IF(TRFLAG(I).EQ.3.0D0) THEN
          DO J=1,NX ! sqrt
           VX(IJSYM(I,J))=VX(IJSYM(I,J))*2.0D0*SQRT(X(I))
           IF(I.EQ.J) VX(IJSYM(I,J))=VX(IJSYM(I,J))*2.0D0*SQRT(X(I))
          END DO
       END IF
      END DO
      IRET=0                    ! set convergence flag
      RETURN

*     eventually stop iterations, or continue --------------------------

   50 CONTINUE 
      IF(NCST.EQ.0.AND.ITER.GE.10.AND.ABS(CHISQ-CHSQP).LT.0.5D0) THEN
         IF(DECXP.LT.(-2.0D0).AND.ABS(DECSL).LT.0.1.AND.IPR.GE.2) THEN
            WRITE(LUNSIM,*) 'Emergency stop: large roundoff errors' 
            GOTO 45 
         END IF 
      END IF 
      NCST=0
      IF(ITER.GT.ITERMX)                       IRET= 2 !!!!
      IF(IRET.LT.0) GOTO 10     ! start next iteration
      ISTAT=0

*     formats ----------------------------------------------------------

  111 FORMAT(1X,I5,    2X,I10,F13.3,E11.2,E11.2,F8.1,F8.1)
  112 FORMAT(1X,I5,'.',I1,I10,13X,E11.2,E11.2)
      END

      SUBROUTINE APRINT(LUNP,JPR)          ! set print option
*
      IMPLICIT NONE
      INTEGER IA,IND,LUNP,JPR
      DOUBLE PRECISION STEP,ARG,XLOW,XHIG
#include "comcfit.inc"
#include "nauxfit.inc"
*     ...
      LUNSIM=LUNP       ! print unit
      IF(LUNSIM.LE.0)     LUNSIM=6
      IPR=JPR           ! print flag
      RETURN

      ENTRY APSTEP(IA,STEP)             ! step size for numdif
      IF(IA.GE.1.AND.IA.LE.NX) THEN
         AUX(NX*NF+IA)=ABS(STEP) ! ST(IA)= ...
      END IF
      RETURN

      ENTRY APLIMT(IA,XLOW,XHIG)        ! range of variable
      IF(IA.GE.1.AND.IA.LE.NX) THEN
         IND=NX*NF+NX+2*(IA-1)
         AUX(IND+1)=MIN(XLOW,XHIG) ! lower limit XL(1,IA)
         AUX(IND+2)=MAX(XLOW,XHIG) ! upper limit XL(2,IA)
      END IF
      RETURN

      ENTRY APDEPS(ARG)                 ! constraint accuracy 
      EPSF  =ARG        ! |F| accuracy
      RETURN

      ENTRY APDERF(ARG)                 ! factor for step definition
      DERFAC=ARG
      RETURN

      ENTRY APDERU(ARG)                 ! factor for step definition
      DERUFC=ARG
      RETURN

      ENTRY APDLOW(ARG)                 ! factor for step definition
      DERLOW=ARG
      RETURN

      ENTRY APITER(IA)                  ! iteration limit 
      ITERMX=MAX(3,IA)  ! max number of iterations 
      RETURN

      ENTRY APOISS(IA)                  ! Poisson distributed variable
      IF(IA.GE.1.AND.IA.LE.NX) THEN
         AUX(INDTR+IA)=+1.0D0
      END IF
      RETURN

      ENTRY APLOGN(IA)                  ! Lognormal distributed variable
      IF(IA.GE.1.AND.IA.LE.NX) THEN 
         AUX(INDTR+IA)=+2.0D0
      END IF
      RETURN 

      ENTRY APSQRT(IA)                  ! SQRT transformation
      IF(IA.GE.1.AND.IA.LE.NX) THEN
         AUX(INDTR+IA)=+3.0D0
      END IF

      END  

